/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs;

import com.google.common.base.Supplier;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.ConfigBuilderImpl;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class ConfigBuilder {
    protected final Map<String, String> translations = new HashMap<String, String>();
    private String currentComment;
    private String currentKey;
    protected Runnable changeCallback;
    protected boolean usesDataBuddy = true;
    private final class_2960 name;
    protected final ConfigType type;
    public static final Predicate<Object> STRING_CHECK = o -> o instanceof String;
    public static final Predicate<Object> LIST_STRING_CHECK = s -> {
        if (s instanceof List) {
            return ((Collection)s).stream().allMatch(o -> o instanceof String);
        }
        return false;
    };

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ConfigBuilder create(class_2960 name, ConfigType type) {
        void var1_1;
        return ConfigBuilderImpl.create(name, (ConfigType)var1_1);
    }

    public static ConfigBuilder create(String modId, ConfigType type) {
        return ConfigBuilder.create(class_2960.method_60655((String)modId, (String)type.getDefaultName()), type);
    }

    protected ConfigBuilder(class_2960 name, ConfigType type) {
        this.name = name;
        this.type = type;
        Consumer<AfterLanguageLoadEvent> consumer = e -> {
            if (e.isDefault()) {
                this.translations.forEach(e::addEntry);
            }
        };
        MoonlightEventsHelper.addListener(consumer, AfterLanguageLoadEvent.class);
    }

    public abstract ModConfigHolder build();

    public class_2960 getName() {
        return this.name;
    }

    public abstract ConfigBuilder push(String var1);

    public abstract ConfigBuilder pop();

    public <T extends ConfigBuilder> T setWriteJsons() {
        this.usesDataBuddy = false;
        return (T)this;
    }

    public abstract java.util.function.Supplier<Boolean> define(String var1, boolean var2);

    public abstract java.util.function.Supplier<Double> define(String var1, double var2, double var4, double var6);

    public abstract java.util.function.Supplier<Float> define(String var1, float var2, float var3, float var4);

    public abstract java.util.function.Supplier<Integer> define(String var1, int var2, int var3, int var4);

    public abstract java.util.function.Supplier<Integer> defineColor(String var1, int var2);

    public abstract java.util.function.Supplier<String> define(String var1, String var2, Predicate<Object> var3);

    public java.util.function.Supplier<String> define(String name, String defaultValue) {
        return this.define(name, defaultValue, STRING_CHECK);
    }

    public <T extends String> java.util.function.Supplier<List<String>> define(String name, List<? extends T> defaultValue) {
        return this.define(name, defaultValue, (Object s) -> true);
    }

    public abstract String currentCategory();

    public abstract <T extends String> java.util.function.Supplier<List<String>> define(String var1, List<? extends T> var2, Predicate<Object> var3);

    public abstract <V extends Enum<V>> java.util.function.Supplier<V> define(String var1, V var2);

    public abstract <T> java.util.function.Supplier<T> defineObject(String var1, Supplier<T> var2, Codec<T> var3);

    public <T> java.util.function.Supplier<List<T>> defineObjectList(String name, Supplier<List<T>> defaultSupplier, Codec<T> codec) {
        return this.defineObject(name, defaultSupplier, codec.listOf());
    }

    public java.util.function.Supplier<Map<String, String>> defineMap(String name, Map<String, String> def) {
        return this.defineObject(name, (Supplier)() -> def, (Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING));
    }

    public java.util.function.Supplier<Map<class_2960, class_2960>> defineIDMap(String name, Map<class_2960, class_2960> def) {
        return this.defineObject(name, (Supplier)() -> def, (Codec)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)class_2960.field_25139));
    }

    public abstract java.util.function.Supplier<JsonElement> defineJson(String var1, JsonElement var2);

    public abstract java.util.function.Supplier<JsonElement> defineJson(String var1, java.util.function.Supplier<JsonElement> var2);

    public java.util.function.Supplier<class_2960> define(String name, class_2960 defaultValue) {
        return new ResourceLocationConfigValue(this, name, defaultValue);
    }

    public class_2561 description(String name) {
        return class_2561.method_43471((String)this.translationKey(name));
    }

    public class_2561 tooltip(String name) {
        return class_2561.method_43471((String)this.tooltipKey(name));
    }

    public String tooltipKey(String name) {
        return this.name.method_12836() + ".configuration." + this.currentCategory() + "." + name + ".description";
    }

    public String translationKey(String name) {
        return this.name.method_12836() + ".configuration." + this.currentCategory() + (String)(name.isEmpty() ? "" : "." + name);
    }

    public ConfigBuilder comment(String comment) {
        this.currentComment = comment;
        if (this.currentComment != null && this.currentKey != null) {
            this.translations.put(this.currentKey, this.currentComment);
            this.currentComment = null;
            this.currentKey = null;
        }
        return this;
    }

    public ConfigBuilder onChange(Runnable callback) {
        this.changeCallback = callback;
        return this;
    }

    public abstract ConfigBuilder worldReload();

    public abstract ConfigBuilder gameRestart();

    protected void addTranslationsAndComments(String name) {
        this.translations.put(this.translationKey(name), LangBuilder.getReadableName(name));
        this.currentKey = this.tooltipKey(name);
        if (this.currentComment != null && this.currentKey != null) {
            this.translations.put(this.currentKey, this.currentComment);
            this.currentComment = null;
            this.currentKey = null;
        }
        if (this.currentCategory() == null && PlatHelper.isDev()) {
            throw new AssertionError((Object)"Current config category was null. How?");
        }
    }

    private static class ResourceLocationConfigValue
    implements java.util.function.Supplier<class_2960> {
        private final java.util.function.Supplier<String> inner;
        private class_2960 cache;
        private String oldString;

        public ResourceLocationConfigValue(ConfigBuilder builder, String path, class_2960 defaultValue) {
            this.inner = builder.define(path, defaultValue.toString(), s -> s != null && class_2960.method_12829((String)((String)s)) != null);
        }

        @Override
        public class_2960 get() {
            String s = this.inner.get();
            if (!s.equals(this.oldString)) {
                this.cache = null;
            }
            this.oldString = s;
            if (this.cache == null) {
                this.cache = class_2960.method_60654((String)s);
            }
            return this.cache;
        }
    }
}

